package gov.va.vamf.scheduling.direct.datalayer.facility;

import gov.va.vamf.scheduling.direct.domain.Institution;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

import java.sql.ResultSet;
import java.sql.SQLException;

@Component
public class InstitutionsResultSetRowMapper implements RowMapper<Institution> {

    @Override
    public Institution mapRow(ResultSet rs, int rowNum) throws SQLException {

        Institution institution = new Institution();

        String institutionName = StringUtils.trimToEmpty(rs.getString(InstitutionResultsColumn.INSTITUTION_NAME.getColumnName()));
        institution.setAuthoritativeName(institutionName);

        String institutionCode = StringUtils.trimToEmpty(rs.getString(InstitutionResultsColumn.INSTITUTION_CODE.getColumnName()));
        institution.setInstitutionCode(institutionCode);

        final String rootStation = StringUtils.trimToEmpty(rs.getString(InstitutionResultsColumn.ROOT_STATION_CODE.getColumnName()));
        institution.setRootStationCode(rootStation);

        final Boolean adminParent = rs.getBoolean(InstitutionResultsColumn.ADMIN_PARENT.getColumnName());
        institution.setAdminParent(adminParent);

        final String parentStation = StringUtils.trimToEmpty(rs.getString(InstitutionResultsColumn.PARENT_STATION_CODE.getColumnName()));
        institution.setParentStationCode(parentStation);

        String city = StringUtils.trimToEmpty(rs.getString(InstitutionResultsColumn.CITY.getColumnName()));
        String state = StringUtils.trimToEmpty(rs.getString(InstitutionResultsColumn.STATE.getColumnName()));
        institution.setCity(city);
        institution.setStateAbbrev(state);

        return (institution);
    }
}